﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Maps;
using System.Diagnostics;
using Mdws2ORM.Core;
using Mdws2ORM.RpcQueries.Commands.Util;
using Mdws2ORM.Exceptions;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.RpcQueries.Commands
{
    public static class ListerCommand
    {
        public static IList<Entry> Execute(QuerySvcSoap client, QueryParam queryParam, ListParam listParam, VistASite vistaSite, string iens = "")
        {
            if (iens.Length > 0 && iens[iens.Length - 1] != ',')
                iens += ",";
            if (queryParam.File.Equals("405.4") && !string.IsNullOrEmpty(listParam.Identity))
                queryParam = new QueryParam(queryParam.File, queryParam.FieldParam.Replace("100;", string.Empty), queryParam.Fields);
            if (queryParam.File.Equals("44.001") && !string.IsNullOrEmpty(listParam.Identity))
            {
                queryParam = new QueryParam(queryParam.File, queryParam.FieldParam.Replace("2;", string.Empty), queryParam.Fields);
                string identity = "S X=\"\" I $D(^SC(4,\"S\",Y,1)) S I=0 F  S I=$O(^SC(4,\"S\",Y,1,I)) Q:+I=0  S X=X_\",\"_$P(^(I,0),U) D EN^DDIOL(Y_U_2_U_X)";
                listParam = new ListParam(listParam.From, listParam.Number, listParam.Screen, listParam.Flags, listParam.Partial, identity, listParam.Index);
            }

            TaggedTextArray rpcResult = client.LIST_DIC(
                queryParam.File,
                iens,
                queryParam.FieldParam,
                listParam.Flags,
                listParam.Number,
                listParam.From,
                listParam.Partial,
                listParam.Index,
                listParam.Screen,
                listParam.Identity);

            RpcUtilities.CheckForFault(rpcResult);
            TaggedText taggetText = rpcResult.results[0];

            if (RpcUtilities.IsResultEmpty(taggetText))
                return new Entry[0];

            if (queryParam.File.Equals("405.4") && !string.IsNullOrEmpty(listParam.Identity))
            {
                Dictionary<string, List<Line>> lines = GetLinesRoomBed(taggetText.text, queryParam.Fields);
                return ProcessLinesRoomBed(lines, queryParam);
            }
            else if (queryParam.File.Equals("44.001") && !string.IsNullOrEmpty(listParam.Identity))
            {
                Dictionary<string, List<Line>> lines = GetLinesClinicAppointment(taggetText.text, queryParam.Fields);
                return ProcessLinesClinicAppointment(lines, queryParam);
            }
            else
            {
                IEnumerable<Line> lines = TextParser.GetLines(taggetText.text);
                return ProcessLines(queryParam, lines);
            }
        }

        private static Entry.Field GetField(Line line)
        {
            return new Entry.Field(line.Field, line.Value);
        }

        private static IList<Entry> ProcessLines(QueryParam queryParam, IEnumerable<Line> lines)
        {
            IList<Entry> result = new List<Entry>();
            string[] fields = queryParam.Fields;
            var lineEnumerator = lines.GetEnumerator();
            while (lineEnumerator.MoveNext())
            {
                Line line = lineEnumerator.Current;
                string ien = line.Ien;
                string file = line.File;
                Entry.Field[] entryFields = new Entry.Field[fields.Length];
                entryFields[0] = GetField(line);

                for (int i = 1; i < fields.Length; i++)
                {
                    lineEnumerator.MoveNext();
                    line = lineEnumerator.Current;

                    if (line.File != queryParam.File)
                        throw new DataException(string.Format("Invalid input. File number {0} expected, but found {1}", queryParam.File, line.File));

                    if (line.Field != fields[i])
                        throw new DataException(string.Format("Invalid input. Field ien {0} expected, but found {1}", fields[i], line.Field));

                    entryFields[i] = GetField(line);
                }
                result.Add(new Entry(file, ien, entryFields));
            }
            return result;
        }

        private static Dictionary<string, List<Line>> GetLinesRoomBed(string text, string[] queryFields)
        {
            List<Line> result = new List<Line>();
            List<string> lines = text.Split('\n').ToList();
            string[] fields = null;
            foreach (string s in lines)
            {
                if (!string.IsNullOrEmpty(s))
                {
                    fields = s.Split('^');
                    if (fields != null && fields.Length == 4)
                        if (queryFields.Contains(fields[2]))
                            result.Add(new Line(fields[0], fields[1], fields[2], fields[3]));
                    if (fields != null && fields.Length == 6)
                        result.Add(new Line(fields[0], fields[3], fields[4], fields[5].Substring(1)));
                }
            }
            return result.OrderBy(a => long.Parse(a.Ien)).ThenBy(a => a.Field).GroupBy(b => b.Ien).ToDictionary(group => group.Key, group => group.ToList());
        }

        private static IList<Entry> ProcessLinesRoomBed(Dictionary<string, List<Line>> lines, QueryParam param)
        {
            IList<Entry> result = new List<Entry>();
            List<Entry.Field> entryFields = null;
            foreach (string key in lines.Keys)
            {
                entryFields = new List<Entry.Field>();
                foreach (Line line in lines[key])
                    entryFields.Add(GetField(line));
                if (entryFields.Count < param.Fields.Length)
                    entryFields.Add(new Entry.Field(param.Fields[2], string.Empty));
                result.Add(new Entry(param.File, key, entryFields.ToArray()));
            }
            return result;
        }

        private static Dictionary<string, List<Line>> GetLinesClinicAppointment(string text, string[] queryFields)
        {
            List<Line> result = new List<Line>();
            List<string> lines = text.Split('\n').ToList();
            string[] fields = null;
            foreach (string s in lines)
            {
                if (!string.IsNullOrEmpty(s))
                {
                    fields = s.Split('^');
                    if (fields != null && fields.Length == 4)
                        if (queryFields.Contains(fields[2]))
                            result.Add(new Line(fields[0], fields[1], fields[2], fields[3]));
                    if (fields != null && fields.Length == 6)
                        result.Add(new Line(fields[0], fields[3], fields[4], fields[5].Substring(1)));
                }
            }
            return result.OrderBy(a => a.Ien).ThenBy(a => a.Field).GroupBy(b => b.Ien).ToDictionary(group => group.Key, group => group.ToList());
        }

        private static IList<Entry> ProcessLinesClinicAppointment(Dictionary<string, List<Line>> lines, QueryParam param)
        {
            IList<Entry> result = new List<Entry>();
            List<Entry.Field> entryFields = null;
            foreach (string key in lines.Keys)
            {
                entryFields = new List<Entry.Field>();
                foreach (Line line in lines[key])
                    entryFields.Add(GetField(line));
                if (entryFields.Count < param.Fields.Length)
                    entryFields.Add(new Entry.Field(param.Fields[2], string.Empty));
                result.Add(new Entry(param.File, key, entryFields.ToArray()));
            }
            return result;
        }
    }
}
